﻿expandMap = function( compact_obj )
{
	var expanded_obj = {};
	expanded_obj.format = 1;
	expanded_obj.width = compact_obj.width;
	expanded_obj.height = compact_obj.height;
	expanded_obj.chipset = compact_obj.chipset;
	
	// tiles
	expanded_obj.layers = [];
	for (lay=0; lay<compact_obj.layers.length; lay++)
	{
		expanded_obj.layers[lay] = [];
		var readIndex = 1;		// skip the _ character
		for (var xx=0; xx<compact_obj.width; xx++)
		{
			expanded_obj.layers[lay][xx] = [];
			for (var yy=0; yy<compact_obj.height; yy++)
			{
				// get data & convert it from:  base-36 string array -> 2D-array of Numbers
				var thisString = compact_obj.layers[lay].substr( readIndex, 2 );
				if(thisString == "0x"){		// 0x is misread as HEX, so handle it manually
					var thisValue = 33;
				}else{
					var thisValue = parseInt( thisString, 36 );
				}
				readIndex += 2;
				expanded_obj.layers[lay][xx][yy] = thisValue;
			}// for:  width
		}// for:  height
	}// for:  layers
	
	
	// collision
	var readIndex = 1;		// skip the _ character
	expanded_obj.collision = [];
	for(var xx=0; xx<compact_obj.width; xx++)
	{
		expanded_obj.collision[xx] = [];
		for(var yy=0; yy<compact_obj.height; yy++)
		{
			// get data & convert it from:  base-36 string array -> 2D-array of Numbers
			var thisString = compact_obj.collision.charAt( readIndex );
			if(thisString == "0x"){		// 0x is misread as HEX, so handle it manually
				var thisValue = 33;
			}else{
				var thisValue = parseInt( thisString, 36 );
			}
			readIndex++;
			// write data
			expanded_obj.collision[xx][yy] = thisValue;
		}// for y
	}// for x
	
	
	
	// output the result
	return expanded_obj;
}// expandMap()